<?php

/**
 * @file
 * Contains bank_account.page.inc.
 *
 * Page callback for Bank account entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Bank account templates.
 *
 * Default template: bank_account.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_bank_account(array &$variables) {
  // Fetch BankAccount Entity Object.
  $bank_account = $variables['elements']['#bank_account'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
