<?php

/**
 * @file
 * Contains bank_transaction.page.inc.
 *
 * Page callback for Bank transaction entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Bank transaction templates.
 *
 * Default template: bank_transaction.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_bank_transaction(array &$variables) {
  // Fetch BankTransaction Entity Object.
  $bank_transaction = $variables['elements']['#bank_transaction'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
