<?php
namespace Drupal\banking_accounting\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

use Drupal\banking\Event\BankTransactionEvent;

/**
 * Class BankingAccountingEventSubscriber.
 *
 * @package Drupal\banking_accounting
 */
class BankingAccountingEventSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events["rules_bank_transaction_created"][] = array('bookBankTransaction', 800);
    return $events;
  }

  /**
   * Subscriber Callback for the event.
   * @param $event
   */
  public function bookBankTransaction(BankTransactionEvent $event) {
    $bank_transaction = $event->bank_transaction;

    if ($bank_transaction->get('state')->value != 'draft') {
      return;
    }

    $s = \Drupal::service('banking_accounting.default');
    $accounts = $s->matchingAccountsForTransaction($bank_transaction);

    if ($accounts && count($accounts) == 1) {
      $account = reset($accounts);
      if ($account->get('state')->value === 'open') {
        try {
          $s->bookBankTransaction($bank_transaction, $account);
        }
        catch (\Exception $e) {
          drupal_set_message($this->t("Could not validate bank transaction :id!", [
            'id' => $bank_transaction->getName(),
          ]));
        }
      }
    }
  }

}
