<?php

namespace Drupal\banking_accounting\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\Core\Url;
use Drupal\accounting\Entity\AccountingAccount;
use Drupal\banking\Entity\BankTransaction;

/**
 * Class BookBankTransactionForm.
 */
class BookBankTransactionForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'book_bank_transaction_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $current_url = Url::fromRoute('<current>')->toString();
    $params = Url::fromUserInput($current_url)->getRouteParameters();
    $form_state->getStorage()['transaction'] = $params['bank_transaction'];

    $transaction = BankTransaction::load($form_state->getStorage()['transaction']);
    $s = \Drupal::service('banking_accounting.default');
    $accounts = $s->matchingAccountsForTransaction($transaction);

    $form['info'] = [
      '#type' => 'fieldset',
      '#title' => 'Transaction',
    ];

    $form['info'][] = \Drupal::service('entity.manager')
      ->getViewBuilder('bank_transaction')
      ->view($transaction);

    $form['account'] = [
      '#type' => 'entity_autocomplete',
      '#title' => $this->t('Account'),
      '#target_type' => 'accounting_account',
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    if ($accounts) {
      $form['account']['#default_value'] = reset($accounts);
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);

    $transaction = BankTransaction::load($form_state->getStorage()['transaction']);
    if ($transaction->getState() != "draft") {
      $form_state->setErrorByName(
        'account',
        t('The bank transaction is not in state draft!'));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
    $transaction = BankTransaction::load($form_state->getStorage()['transaction']);

    $s = \Drupal::service('banking_accounting.default');
    $s->bookBankTransaction($transaction, AccountingAccount::load($values['account']));
  }

}
