<?php
namespace Drupal\banking_accounting\Plugin\views\field;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Field handler to display the formatted OGM's for an account.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("account_ogm_formatted")
 */
class FormattedOGM extends FieldPluginBase {

  /**
   * @{inheritdoc}
   */
  public function query() {
    // Leave empty to avoid a query on this field.
  }

  /**
   * @{inheritdoc}
   */
  public function render(ResultRow $values) {
    if (!$this->getEntity($values)) {
      return '';
    }

    $account = $this->getEntity($values);
    return implode(', ', array_map(
        function ($o) {
          return $o->getFormattedOGM();
        },
        \Drupal::service('banking_accounting.default')->ogmsForAccount($account)
    ));
  }
}
