<?php

/**
 * @file
 * Contains payment_order.page.inc.
 *
 * Page callback for Payment order entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Payment order templates.
 *
 * Default template: payment_order.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_payment_order(array &$variables) {
  // Fetch PaymentOrder Entity Object.
  $payment_order = $variables['elements']['#payment_order'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
