<?php

namespace Drupal\banking_export\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Payment order entities.
 *
 * @ingroup banking_export
 */
interface PaymentOrderInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Payment order name.
   *
   * @return string
   *   Name of the Payment order.
   */
  public function getName();

  /**
   * Sets the Payment order name.
   *
   * @param string $name
   *   The Payment order name.
   *
   * @return \Drupal\banking_export\Entity\PaymentOrderInterface
   *   The called Payment order entity.
   */
  public function setName($name);

  /**
   * Gets the Payment order creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Payment order.
   */
  public function getCreatedTime();

  /**
   * Sets the Payment order creation timestamp.
   *
   * @param int $timestamp
   *   The Payment order creation timestamp.
   *
   * @return \Drupal\banking_export\Entity\PaymentOrderInterface
   *   The called Payment order entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the Payment order published status indicator.
   *
   * Unpublished Payment order are only visible to restricted users.
   *
   * @return bool
   *   TRUE if the Payment order is published.
   */
  public function isPublished();

  /**
   * Sets the published status of a Payment order.
   *
   * @param bool $published
   *   TRUE to set this Payment order to published, FALSE to set it to unpublished.
   *
   * @return \Drupal\banking_export\Entity\PaymentOrderInterface
   *   The called Payment order entity.
   */
  public function setPublished($published);

}
