<?php

namespace Drupal\banking_export\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Payment order line entities.
 *
 * @ingroup banking_export
 */
interface PaymentOrderLineInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Payment order line name.
   *
   * @return string
   *   Name of the Payment order line.
   */
  public function getName();

  /**
   * Sets the Payment order line name.
   *
   * @param string $name
   *   The Payment order line name.
   *
   * @return \Drupal\banking_export\Entity\PaymentOrderLineInterface
   *   The called Payment order line entity.
   */
  public function setName($name);

  /**
   * Gets the Payment order line creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Payment order line.
   */
  public function getCreatedTime();

  /**
   * Sets the Payment order line creation timestamp.
   *
   * @param int $timestamp
   *   The Payment order line creation timestamp.
   *
   * @return \Drupal\banking_export\Entity\PaymentOrderLineInterface
   *   The called Payment order line entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the Payment order line published status indicator.
   *
   * Unpublished Payment order line are only visible to restricted users.
   *
   * @return bool
   *   TRUE if the Payment order line is published.
   */
  public function isPublished();

  /**
   * Sets the published status of a Payment order line.
   *
   * @param bool $published
   *   TRUE to set this Payment order line to published, FALSE to set it to unpublished.
   *
   * @return \Drupal\banking_export\Entity\PaymentOrderLineInterface
   *   The called Payment order line entity.
   */
  public function setPublished($published);

}
