<?php

namespace Drupal\banking_export\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Payment order line edit forms.
 *
 * @ingroup banking_export
 */
class PaymentOrderLineForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    /* @var $entity \Drupal\banking_export\Entity\PaymentOrderLine */
    $form = parent::buildForm($form, $form_state);

    $entity = $this->entity;

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $entity = $this->entity;

    $status = parent::save($form, $form_state);

    switch ($status) {
      case SAVED_NEW:
        drupal_set_message($this->t('Created the %label Payment order line.', [
          '%label' => $entity->label(),
        ]));
        break;

      default:
        drupal_set_message($this->t('Saved the %label Payment order line.', [
          '%label' => $entity->label(),
        ]));
    }
    $form_state->setRedirect('entity.payment_order_line.canonical', ['payment_order_line' => $entity->id()]);
  }

}
