<?php

namespace Drupal\banking_export;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Payment order entity.
 *
 * @see \Drupal\banking_export\Entity\PaymentOrder.
 */
class PaymentOrderAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\banking_export\Entity\PaymentOrderInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished payment order entities');
        }
        return AccessResult::allowedIfHasPermission($account, 'view published payment order entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit payment order entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete payment order entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add payment order entities');
  }

}
