<?php

namespace Drupal\banking_export;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Payment order line entity.
 *
 * @see \Drupal\banking_export\Entity\PaymentOrderLine.
 */
class PaymentOrderLineAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\banking_export\Entity\PaymentOrderLineInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished payment order line entities');
        }
        return AccessResult::allowedIfHasPermission($account, 'view published payment order line entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit payment order line entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete payment order line entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add payment order line entities');
  }

}
