<?php

namespace Drupal\banking_export;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Payment order line entities.
 *
 * @ingroup banking_export
 */
class PaymentOrderLineListBuilder extends EntityListBuilder {


  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('Payment order line ID');
    $header['name'] = $this->t('Name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\banking_export\Entity\PaymentOrderLine */
    $row['id'] = $entity->id();
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.payment_order_line.edit_form',
      ['payment_order_line' => $entity->id()]
    );
    return $row + parent::buildRow($entity);
  }

}
