<?php

namespace Drupal\banking_export;

use Drupal\banking_export\Entity\PaymentOrder;
use Drupal\banking_export\Entity\PaymentOrderInterface;
use Drupal\banking_export\Entity\PaymentOrderLine;

/**
 * Class PaymentOrderService.
 */
class PaymentOrderService implements PaymentOrderServiceInterface {

  /**
   * Constructs a new PaymentOrderService object.
   */
  public function __construct() {

  }

  /**
   * {@inheritdoc}
   */
  public function createPaymentOrder($name) {
    $order = PaymentOrder::create([
      'name' => $name,
    ]);
    $order->save();
    return $order;
  }

  /**
   * {@inheritdoc}
   */
  public function createPaymentOrderLine(PaymentOrderInterface $order, $accountholder, $account_number, $amount, $info) {
    $line = PaymentOrderLine::create([
      'payment_order' => $order,
      'accountholder' => $accountholder,
      'account_number' => $account_number,
      'amount' => $amount,
      'name' => $info,
    ]);
    $line->save();
    return $line;
  }


}
