<?php

namespace Drupal\banking_export\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\banking_export\Entity\PaymentOrderLine;

/**
 * Plugin implementation of the 'payment_order_line_formatter' formatter.
 *
 * @FieldFormatter(
 *   id = "payment_order_line_formatter",
 *   label = @Translation("Payment Order Line Formatter"),
 *   field_types = {
 *     "payment_order_line"
 *   }
 * )
 */
class PaymentOrderLineFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      // Implement default settings.
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    return [
      // Implement settings form.
    ] + parent::settingsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    // Implement settings summary.

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = $this->viewValue($item);
    }

    return $elements;
  }

  /**
   * Generate the output appropriate for one field item.
   *
   * @param \Drupal\Core\Field\FieldItemInterface $item
   *   One field item.
   *
   * @return string
   *   The textual output generated.
   */
  protected function viewValue(FieldItemInterface $item) {
    $value = $item->getValue();
    if (isset($value['entity'])) {
      $entity = $value['entity'];
    }
    else {
      $entity = PaymentOrderLine::load($value['target_id']);
    }

    return [
      '#markup' => $entity->label(),
    ];
  }

}
