<?php

/**
 * @file
 * Contains banking_import.drush.inc.
 */

/**
 * Implements hook_drush_command().
 */
function banking_import_drush_command() {
  $commands['import-bank-file'] = [
    'description' => 'This command will import a bank transaction file.',
    'aliases' => ['import-bank-file'],
    'arguments' => [
      'format' => 'The format of the file.',
      'file' => 'The file to import.',
     ],
     'options' => [
     ],
     'examples' => [
     ],
  ];

  return $commands;
}


/**
 * Drush command logic.
 *
 * Implements hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_banking_import_import_bank_file($format, $file) {
  $definition = \Drupal::service('plugin.manager.banking_import_format_definitions')
    ->createInstance($format, []);
  $batch = $definition->importFileBatch(
    file_save_data(file_get_contents($file), 'private://' . basename($file)));

  batch_set($batch);

  $batch =& batch_get();
  $batch['progressive'] = FALSE;

  // Process the batch.
  drush_backend_batch_process();
}
