<?php

namespace Drupal\banking_import;

use Drupal\Core\Messenger\MessengerInterface;

use Drupal\banking\Entity\BankTransaction;
use Drupal\banking\Event\BankTransactionEvent;

/**
 * Class BankingImportService.
 */
class BankingImportService implements BankingImportServiceInterface {

  /**
   * Drupal\Core\Messenger\MessengerInterface definition.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface
   */
  protected $messenger;

  /**
   * Constructs a new BankingImportService object.
   */
  public function __construct(MessengerInterface $messenger) {
    $this->messenger = $messenger;
  }

  /**
   * Create a new imported bank transaction.
   */
  public function createImportedTransaction($transaction_data) {
    $transaction = BankTransaction::create($transaction_data);
    $transaction->save();

    $event = new BankTransactionEvent($transaction);
    $event_dispatcher = \Drupal::service('event_dispatcher');
    try {
      $event_dispatcher->dispatch('rules_bank_transaction_created', $event);
    }
    catch (\Exception $e) {
      $this->messenger->addWarning("Error while processing transaction {$transaction->getName()}.");
    }
  }

}
