<?php

namespace Drupal\banking_import\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * {@inheritdoc}
 */
class BankingImportFormatDefinitionManager extends DefaultPluginManager {

  /**
   * {@inheritdoc}
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/BankingImportFormat',
      $namespaces,
      $module_handler,
      'Drupal\banking_import\Plugin\BankingImportFormatDefinitionInterface',
      'Drupal\banking_import\Annotation\BankingImportFormatDefinition');

    $this->alterInfo('banking_import_format_definition_info');
    $this->setCacheBackend($cache_backend, 'banking_import_format_definitions');
  }
}
