<?php

/**
 * @file
 * Contains banking_ogm.page.inc.
 *
 * Page callback for Banking OGM entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Banking OGM templates.
 *
 * Default template: banking_ogm.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_banking_ogm(array &$variables) {
  // Fetch BankingOGM Entity Object.
  $banking_ogm = $variables['elements']['#banking_ogm'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
