<?php

namespace Drupal\banking_ogm;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Banking OGM entity.
 *
 * @see \Drupal\banking_ogm\Entity\BankingOGM.
 */
class BankingOGMAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\banking_ogm\Entity\BankingOGMInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished banking ogm entities');
        }
        return AccessResult::allowedIfHasPermission($account, 'view published banking ogm entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit banking ogm entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete banking ogm entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add banking ogm entities');
  }

}
