<?php

namespace Drupal\banking_ogm;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Banking OGM entities.
 *
 * @ingroup banking_ogm
 */
class BankingOGMListBuilder extends EntityListBuilder {


  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('Banking OGM ID');
    $header['name'] = $this->t('Name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\banking_ogm\Entity\BankingOGM */
    $row['id'] = $entity->id();
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.banking_ogm.edit_form',
      ['banking_ogm' => $entity->id()]
    );
    return $row + parent::buildRow($entity);
  }

}
