<?php

namespace Drupal\banking_ogm\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Banking OGM entities.
 *
 * @ingroup banking_ogm
 */
interface BankingOGMInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Banking OGM name.
   *
   * @return string
   *   Name of the Banking OGM.
   */
  public function getName();

  /**
   * Sets the Banking OGM name.
   *
   * @param string $name
   *   The Banking OGM name.
   *
   * @return \Drupal\banking_ogm\Entity\BankingOGMInterface
   *   The called Banking OGM entity.
   */
  public function setName($name);

  /**
   * Gets the Banking OGM creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Banking OGM.
   */
  public function getCreatedTime();

  /**
   * Sets the Banking OGM creation timestamp.
   *
   * @param int $timestamp
   *   The Banking OGM creation timestamp.
   *
   * @return \Drupal\banking_ogm\Entity\BankingOGMInterface
   *   The called Banking OGM entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the Banking OGM published status indicator.
   *
   * Unpublished Banking OGM are only visible to restricted users.
   *
   * @return bool
   *   TRUE if the Banking OGM is published.
   */
  public function isPublished();

  /**
   * Sets the published status of a Banking OGM.
   *
   * @param bool $published
   *   TRUE to set this Banking OGM to published, FALSE to set it to unpublished.
   *
   * @return \Drupal\banking_ogm\Entity\BankingOGMInterface
   *   The called Banking OGM entity.
   */
  public function setPublished($published);

}
