<?php

namespace Drupal\banking_ogm\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Banking OGM type entity.
 *
 * @ConfigEntityType(
 *   id = "banking_ogm_type",
 *   label = @Translation("Banking OGM type"),
 *   handlers = {
 *     "view_builder" = "Drupal\Core\Entity\EntityViewBuilder",
 *     "list_builder" = "Drupal\banking_ogm\BankingOGMTypeListBuilder",
 *     "form" = {
 *       "add" = "Drupal\banking_ogm\Form\BankingOGMTypeForm",
 *       "edit" = "Drupal\banking_ogm\Form\BankingOGMTypeForm",
 *       "delete" = "Drupal\banking_ogm\Form\BankingOGMTypeDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\banking_ogm\BankingOGMTypeHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "banking_ogm_type",
 *   admin_permission = "administer site configuration",
 *   bundle_of = "banking_ogm",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "canonical" = "/admin/banking/config/banking_ogm_type/{banking_ogm_type}",
 *     "add-form" = "/admin/banking/config/banking_ogm_type/add",
 *     "edit-form" = "/admin/banking/config/banking_ogm_type/{banking_ogm_type}/edit",
 *     "delete-form" = "/admin/banking/config/banking_ogm_type/{banking_ogm_type}/delete",
 *     "collection" = "/admin/banking/config/banking_ogm_type"
 *   }
 * )
 */
class BankingOGMType extends ConfigEntityBundleBase implements BankingOGMTypeInterface {

  /**
   * The Banking OGM type ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Banking OGM type label.
   *
   * @var string
   */
  protected $label;

  /**
   * The Banking OGM prefix.
   *
   * @var string
   */
  protected $prefix;

  /**
   * {@inheritdoc}
   */
  public function getPrefix() {
    return $this->prefix;
  }

  /**
   * {@inheritdoc}
   */
  public function setPrefix($prefix) {
    $this->prefix = $prefix;
    return $this;
  }

}
