<?php

namespace Drupal\banking_ogm\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for Banking OGM edit forms.
 *
 * @ingroup banking_ogm
 */
class BankingOGMForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    /* @var $entity \Drupal\banking_ogm\Entity\BankingOGM */
    $form = parent::buildForm($form, $form_state);

    $entity = $this->entity;

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);

    $name = $form_state->getValue('name')[0]['value']; // FIXME: [0]['value']
    if (strlen($name) != 10 || !preg_match('/^[0-9]{10}$/', $name)) {
      $form_state->setErrorByName('name', t("The OGM should be exactly 10 digits!"));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $entity = $this->entity;

    $status = parent::save($form, $form_state);

    switch ($status) {
      case SAVED_NEW:
        drupal_set_message($this->t('Created the %label Banking OGM.', [
          '%label' => $entity->label(),
        ]));
        break;

      default:
        drupal_set_message($this->t('Saved the %label Banking OGM.', [
          '%label' => $entity->label(),
        ]));
    }
    $form_state->setRedirect('entity.banking_ogm.canonical', ['banking_ogm' => $entity->id()]);
  }

}
