<?php

namespace Drupal\banking_ogm\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class BankingOGMTypeForm.
 */
class BankingOGMTypeForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $banking_ogm_type = $this->entity;
    $form['label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label'),
      '#maxlength' => 255,
      '#default_value' => $banking_ogm_type->label(),
      '#description' => $this->t("Label for the Banking OGM type."),
      '#required' => TRUE,
    ];

    $form['prefix'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Prefix'),
      '#maxlength' => 3,
      '#default_value' => $banking_ogm_type->getPrefix(),
      '#description' => $this->t("Prefix for the Banking OGM type."),
    ];

    $form['id'] = [
      '#type' => 'machine_name',
      '#default_value' => $banking_ogm_type->id(),
      '#machine_name' => [
        'exists' => '\Drupal\banking_ogm\Entity\BankingOGMType::load',
      ],
      '#disabled' => !$banking_ogm_type->isNew(),
    ];

    /* You will need additional form elements for your custom properties. */

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);

    $prefix = $form_state->getValue('prefix');
    if (strlen($prefix) != 3 || !preg_match('/^[0-9]{3}$/', $prefix)) {
      $form_state->setErrorByName('prefix', t("The OGM prefix should be exactly 3 digits!"));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {

    $banking_ogm_type = $this->entity;
    $banking_ogm_type->setPrefix($form_state->getValue('prefix'));

    $status = $banking_ogm_type->save();

    switch ($status) {
      case SAVED_NEW:
        drupal_set_message($this->t('Created the %label Banking OGM type.', [
          '%label' => $banking_ogm_type->label(),
        ]));
        break;

      default:
        drupal_set_message($this->t('Saved the %label Banking OGM type.', [
          '%label' => $banking_ogm_type->label(),
        ]));
    }
    $form_state->setRedirectUrl($banking_ogm_type->toUrl('collection'));
  }

}
