<?php

namespace Drupal\banking;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Bank account entities.
 *
 * @ingroup banking
 */
class BankAccountListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['name'] = $this->t('Name');
    $header['iban'] = $this->t('IBAN');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\banking\Entity\BankAccount */
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.bank_account.canonical',
      ['bank_account' => $entity->id()]
    );
    $row['iban'] = $entity->get('iban')->iban;

    return $row + parent::buildRow($entity);
  }

}
