<?php

namespace Drupal\banking;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Bank transaction entity.
 *
 * @see \Drupal\banking\Entity\BankTransaction.
 */
class BankTransactionAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\banking\Entity\BankTransactionInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished bank transaction entities');
        }
        return AccessResult::allowedIfHasPermission($account, 'view published bank transaction entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit bank transaction entities');

      case 'delete':
        if ($entity->getState() != 'draft') {
          return AccessResult::forbidden();
        }
        return AccessResult::allowedIfHasPermission($account, 'delete bank transaction entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add bank transaction entities');
  }

}
