<?php

namespace Drupal\banking;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Bank transaction entities.
 *
 * @ingroup banking
 */
class BankTransactionListBuilder extends EntityListBuilder {


  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['number'] = $this->t('Number');
    $header['transaction-date'] = $this->t('Transaction Date');
    $header['amount'] = $this->t('Amount');
    $header['account-number'] = $this->t('Account number');
    $header['account-holder-name'] = $this->t('Account holder name');
    $header['account-holder-address'] = $this->t('Account holder address');
    $header['information'] = $this->t('Information');
    $header['state'] = $this->t('State');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\banking\Entity\BankTransaction */
    $row['number'] = Link::createFromRoute(
      $entity->label(),
      'entity.bank_transaction.canonical',
      ['bank_transaction' => $entity->id()]
    );
    $row['transaction-date'] = $entity->getDate();
    $row['amount'] = $entity->getAmount();
    $row['account-number'] = $entity->getAccountNumber();
    $row['account-holder-name'] = $entity->getAccountHolderName();
    $row['account-holder-address'] = $entity->getAccountHolderAddress();
    $row['information'] = $entity->getInformation();
    $row['state'] = $entity->getState();
    return $row + parent::buildRow($entity);
  }

  /**
   * Gets Bank Transaction default operations.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity the operations are for.
   *
   * @return array
   *   The array structure is identical to the return value of
   *   self::getOperations().
   */
  protected function getDefaultOperations(EntityInterface $entity) {
    $operations = parent::getDefaultOperations($entity);

    $operations['bank-transaction-state'] = [
      'title' => $this->t('Change State'),
      'weight' => 10,
      'url' => $entity->urlInfo('state-form'),
    ];

    return $operations;
  }

}
