<?php

namespace Drupal\banking\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Bank account entities.
 *
 * @ingroup banking
 */
interface BankAccountInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Bank account name.
   *
   * @return string
   *   Name of the Bank account.
   */
  public function getName();

  /**
   * Sets the Bank account name.
   *
   * @param string $name
   *   The Bank account name.
   *
   * @return \Drupal\banking\Entity\BankAccountInterface
   *   The called Bank account entity.
   */
  public function setName($name);

  /**
   * Gets the Bank account creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Bank account.
   */
  public function getCreatedTime();

  /**
   * Sets the Bank account creation timestamp.
   *
   * @param int $timestamp
   *   The Bank account creation timestamp.
   *
   * @return \Drupal\banking\Entity\BankAccountInterface
   *   The called Bank account entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the Bank account published status indicator.
   *
   * Unpublished Bank account are only visible to restricted users.
   *
   * @return bool
   *   TRUE if the Bank account is published.
   */
  public function isPublished();

  /**
   * Sets the published status of a Bank account.
   *
   * @param bool $published
   *   TRUE to set this Bank account to published, FALSE to set it to unpublished.
   *
   * @return \Drupal\banking\Entity\BankAccountInterface
   *   The called Bank account entity.
   */
  public function setPublished($published);

}
