<?php

namespace Drupal\banking\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Bank transaction entities.
 *
 * @ingroup banking
 */
interface BankTransactionInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Bank transaction name.
   *
   * @return string
   *   Name of the Bank transaction.
   */
  public function getName();

  /**
   * Sets the Bank transaction name.
   *
   * @param string $name
   *   The Bank transaction name.
   *
   * @return \Drupal\banking\Entity\BankTransactionInterface
   *   The called Bank transaction entity.
   */
  public function setName($name);

  /**
   * Gets the Bank transaction amount.
   *
   * @return decimal
   *   Amount of the Bank transaction.
   */
  public function getAmount();

  /**
   * Gets the Bank transaction creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Bank transaction.
   */
  public function getCreatedTime();

  /**
   * Sets the Bank transaction creation timestamp.
   *
   * @param int $timestamp
   *   The Bank transaction creation timestamp.
   *
   * @return \Drupal\banking\Entity\BankTransactionInterface
   *   The called Bank transaction entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the Bank transaction published status indicator.
   *
   * Unpublished Bank transaction are only visible to restricted users.
   *
   * @return bool
   *   TRUE if the Bank transaction is published.
   */
  public function isPublished();

  /**
   * Sets the published status of a Bank transaction.
   *
   * @param bool $published
   *   TRUE to set this Bank transaction to published, FALSE to set it to unpublished.
   *
   * @return \Drupal\banking\Entity\BankTransactionInterface
   *   The called Bank transaction entity.
   */
  public function setPublished($published);

}
