<?php
namespace Drupal\banking\Event;

use Drupal\banking\Entity\BankTransactionInterface;
use Symfony\Component\EventDispatcher\Event;


/**
 * Bank TransactionEvent.
 *
 */
class BankTransactionEvent extends Event {

  const EVENT_NAME = 'rules_bank_transaction';

  /**
   * The bank transaction.
   *
   * @var \Drupal\banking\Entity\BankTransactionInterface
   */
  public $bank_transaction;

  /**
   * Constructs the object.
   *
   * @param \Drupal\banking\Entity\BankTransactionInterface $bank_transaction
   *   The Bank Transaction.
   */
  public function __construct(BankTransactionInterface $bank_transaction) {
    $this->bank_transaction = $bank_transaction;
  }

}