<?php

namespace Drupal\banking\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

use Drupal\banking\Entity\BankTransaction;

/**
 * Class BankTransactionStateForm.
 */
class BankTransactionStateForm extends FormBase {


  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'bank_transaction_state_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $current_url = Url::fromRoute('<current>')->toString();
    $params = Url::fromUserInput($current_url)->getRouteParameters();
    $transaction = BankTransaction::load($params['bank_transaction']);
    $form_state->getStorage()['transaction'] = $params['bank_transaction'];

    $form['state'] = [
      '#type' => 'select',
      '#title' => $this->t('State'),
      '#description' => $this->t('State of the transaction.'),
      '#options' => [
        'draft' => $this->t('draft'),
        'manual' => $this->t('manual'),
        'done' => $this->t('done'),
      ],
      '#default_value' => $transaction->getState(),
      '#weight' => '0',
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $transaction = BankTransaction::load($form_state->getStorage()['transaction']);
    $transaction->setState($form_state->getValue('state'));
    $transaction->save();
    $form_state->setRedirect('entity.bank_transaction.canonical', ['bank_transaction' => $transaction->id()]);
  }

}
