<?php
namespace Drupal\banking\Plugin\Action;

use Drupal\views_bulk_operations\Action\ViewsBulkOperationsActionBase;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Change Transaction State.
 *
 * @Action(
 *   id = "change_transaction_state_action",
 *   label = @Translation("Change Transaction State"),
 *   type = "bank_transaction"
 * )
 */
class ChangeTransactionStateAction extends ViewsBulkOperationsActionBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'state' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['state'] = [
      '#type' => 'select',
      '#title' => $this->t('State'),
      '#description' => $this->t('State of the transaction.'),
      '#options' => [
        'draft' => $this->t('draft'),
        'manual' => $this->t('manual'),
        'done' => $this->t('done'),
      ],
      '#required' => TRUE,
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    $entity->setState($this->configuration['state']);
    $entity->save();
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    if ($object->getState() != 'draft') {
      $result = AccessResult::forbidden();
    }
    else {
      $result = $object->access('update', $account, TRUE);
    }
    return $return_as_object ? $result : $result->isAllowed();
  }

}
