<?php

namespace Drupal\banking\Plugin\WorkflowType;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\workflows\Plugin\WorkflowTypeBase;

/**
 * Bank Transaction workflow type.
 *
 * @WorkflowType(
 *   id = "workflow_bank_transaction",
 *   label = @Translation("Bank Transaction Workflow"),
 *   required_states = {
 *     "draft",
 *     "manual",
 *     "done",
 *   }
 * )
 */
class BankTransactionWorkflowType extends WorkflowTypeBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'states' => [
        'draft' => [
          'label' => 'Draft',
          'weight' => 0,
        ],
        'manual' => [
          'label' => 'Manual',
          'weight' => 1,
        ],
        'done' => [
          'label' => 'Done',
          'weight' => 2,
        ],
      ],
      'transitions' => [
        'validate' => [
          'label' => 'Validate',
          'to' => 'done',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
        'manual' => [
          'label' => 'Manual',
          'to' => 'manual',
          'weight' => 0,
          'from' => [
            'draft',
          ],
        ],
      ],
    ];
  }

}
