<?php

namespace Drupal\Tests\banking\Kernel;

use Drupal\KernelTests\KernelTestBase;

use Drupal\banking\Entity\BankTransaction;

use Drupal\banking\Exception\BankingIntegrityException;

/**
 * Banking Order tests.
 *
 * @group banking
 */
class BankingIntegrityTest extends KernelTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  public static $modules = [
    'system',
    'user',
    'file',
    'text',
    'datetime',
    'simple_workflows',
    'banking',
    'iban_field',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp() {
    parent::setUp();
    $this->installEntitySchema('user');
    $this->installEntitySchema('bank_transaction');
  }

  /**
   * Test delete non-draft bank transaction.
   */
  public function testDeleteBankTransaction() {
    $t = BankTransaction::create([
           'name' => 'test',
    ]);
    $t->set('state', 'valid')->save();

    $this->expectException(BankingIntegrityException::class);
    $t->delete();
  }

}
