<?php

/**
 * @file
 */

use Symfony\Component\Yaml\Yaml;

/**
 * Implements hook_drush_command().
 */
function dsr_drush_command() {

  $commands['overwrite-config'] = [
    'description' => 'This command will overwrite an existing config entity.',
    'aliases' => ['oc'],
    'arguments' => [],
    'options' => [],
    'examples' => [
      'drush oc <file>' => 'overwrite config file.',
    ],
  ];
  $commands['update-config-translations'] = [
    'description' => 'This command will overwrite an existing config entity.',
    'aliases' => [],
    'arguments' => [],
    'options' => [],
    'examples' => [],
  ];

  $commands['import-shareholder-register'] = [
    'description' => 'This command will import the existing register.',
    'aliases' => [],
    'arguments' => [
      'directory' => "Directory containing 'shareholders.csv' and 'share_transactions.csv'.",
    ],
    'options' => [],
    'examples' => [],
  ];
  $commands['validate-shareholder-register'] = [
    'description' => 'This command will validate the imported transactions from the existing register.',
    'aliases' => [],
    'arguments' => [],
    'options' => [],
    'examples' => [],
  ];

  $commands['copy-account-number-to-iban-bic'] = [
    'description' => 'This command will copy a string account number field to a iban bic field.',
    'aliases' => [],
    'arguments' => [
      'entity' => 'The entity',
      'account' => 'The source (textfield) account number field.',
      'iban' => 'The destiny (iban_bic) iban field.',
    ],
    'options' => [],
    'examples' => [],
  ];

  return $commands;
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_dsr_overwrite_config($file = '') {
  drush_print('overwriting config file');
  if (!file_exists($file)) {
    drush_print("File {$file} does not exist!", 0, STDERR);
    exit(1);
  }

  $config_name = basename($file, '.yml');
  $config_data = $rewrite = Yaml::parse(file_get_contents($file));
  $config = \Drupal::service('config.factory')->getEditable($config_name);
  $config->setData($config_data)->save();

}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_dsr_update_config_translations() {
  \Drupal::moduleHandler()->loadInclude('locale', 'bulk.inc');
  if ($batch = locale_config_batch_update_components([])) {
    batch_set($batch);
    $batch =& batch_get();
    $batch['progressive'] = FALSE;

    // Process the batch.
    drush_backend_batch_process();
  }
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_dsr_import_shareholder_register($directory) {
  \Drupal::service('dsr.drush')->importShareholderRegister($directory);
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_dsr_validate_shareholder_register() {
  \Drupal::service('dsr.drush')->importShareholderRegisterValidate();
}

/**
 * Drush command logic.
 *
 * Hook drush_[MODULE_NAME]_[COMMAND_NAME]().
 */
function drush_dsr_copy_account_number_to_iban_bic($entity, $account, $iban) {
  \Drupal::service('dsr.drush')->copyAccountNumberToIbanBic($entity, $account, $iban);
}
