<?php

namespace Drupal\dsr_dashboard\Plugin\Block;

use Drupal\Core\Block\BlockBase;

use Drupal\shareholder_register\Entity\ShareType;

/**
 * Provides a 'Dsr Dashboard' Block.
 *
 * @Block(
 *   id = "dsr_dashboard_block",
 *   admin_label = @Translation("DSR Dashboard Block"),
 *   category = @Translation("DSR Dashboard Block"),
 * )
 */
class DsrDashboardBlock extends BlockBase {

  private $palette = [
    "#aadae2",
    "#dd514e",
    "#abecec",
    "#e51000",
    "#42c8c6",
    "#6b0603",
    "#00bee7",
    "#09394c",
  ];

  /**
   * {@inheritdoc}
   */
  public function build() {
    $share_type_ids = \Drupal::entityQuery('share_type')->accessCheck(FALSE)->execute();

    $categories = [];
    $series = [];

    foreach (ShareType::loadMultiple($share_type_ids) as $share_type) {
      $serie = [
        "name" => $share_type->getName(),
        "color" => $this->palette[count($series) % count($this->palette)],
        "data" => [],
      ];

      $categories = [];
      foreach (
        \Drupal::database()->query("
          SELECT t.id,
                 t.date,
                 (@running_total := @running_total + case when t.share_type_id = :share_type_id then t.quantity else 0 end) AS cumulative_sum
          FROM share_transaction as t
          JOIN (SELECT @running_total := 0) r
          WHERE t.state = 'valid'
          ORDER BY t.date
          ", [':share_type_id' => $share_type->id()]) as $row) {

        $serie["data"][] = intval($row->cumulative_sum);
        $categories[] = $row->date;
      }
      $series[] = $serie;
    }

    $build = [
      '#theme' => 'charts_blocks',
      '#library' => 'google',
      '#categories' => $categories,
      '#seriesData' => $series,
      '#options' => [
        'library' => 'google',
        'type' => 'area',
        'grouping' => 1,
        'title' => 'share history',
        'legend_position' => 'none',
        'title_position' => 'none',
        'background' => 'transparent',
      ],
      '#secondaryOptions' => [],
      '#id' => "chart-600f02f5-e7c8-420d-8dd3-a7f058",
      '#cache' => \Drupal::entityTypeManager()->getDefinition('share_transaction')->getListCacheTags(),
    ];

    return $build;
  }

}
