<?php

namespace Drupal\dsr_deposito;

use Drupal\banking_ogm\Entity\BankingOGM;
use Drupal\shareholder_register\Entity\ShareholderInterface;

/**
 * Class DsrDepositoService.
 */
class DsrDepositoService implements DsrDepositoServiceInterface {

  /**
   * Constructs a new DsrDepositoService object.
   */
  public function __construct() {

  }

  /**
   * {@inheritdoc}
   */
  public function OgmForShareholder(ShareholderInterface $shareholder, string $account_bundle = '') {
    $ogm_query = \Drupal::entityQuery('banking_ogm')
      ->accessCheck(FALSE)
      ->condition('account.entity.field_shareholder.target_id', $shareholder->id());

    if ($account_bundle) {
      $ogm_query = $ogm_query->condition('account.entity.type', $account_bundle);
    }

    $ogm_ids = $ogm_query->execute();
    if (!$ogm_ids) {
      return [];
    }

    return BankingOGM::loadMultiple($ogm_ids);
  }

}
