<?php

namespace Drupal\dsr_deposito\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\shareholder_register\Entity\ShareIssue;

/**
 * Class DSRDepositoConfigForm.
 */
class DSRDepositoConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'dsr_deposito.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dsr_deposito_config_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('dsr_deposito.settings');
    $share_issue = ShareIssue::load($config->get('share_issue'));
    $form['deposito_account_bundle'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Deposito account bundle'),
      '#maxlength' => 64,
      '#size' => 64,
      '#default_value' => $config->get('deposito_account_bundle'),
    ];
    $form['share_issue'] = [
      '#type' => 'entity_autocomplete',
      '#title' => $this->t('Share Issue'),
      '#target_type' => 'share_issue',
      '#default_value' => $share_issue,
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('dsr_deposito.settings')
      ->set('deposito_account_bundle', $form_state->getValue('deposito_account_bundle'))
      ->set('share_issue', $form_state->getValue('share_issue'))
      ->save();
  }

}
