<?php

namespace Drupal\dsr_deposito\Plugin\views\field;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Field handler to show formatted Ogm's for shareholders.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("dsr_ogm_formatted")
 */
class ShareholderOgm extends FieldPluginBase {

  /**
   * @{inheritdoc}
   */
  public function query() {
    // Leave empty to avoid a query on this field.
  }

  /**
   * Define the available options.
   *
   * @return array
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    return $options;
  }

  /**
   * Provide the options form.
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);
  }

  /**
   * @{inheritdoc}
   */
  public function render(ResultRow $values) {
    $result = [
      '#markup' => '',
      '#cache' => [
        'tags' => \Drupal::entityTypeManager()->getDefinition('banking_ogm')->getListCacheTags(),
      ],
    ];

    if (!($shareholder = $this->getEntity($values))) {
      return $result;
    }

    $ogms = \Drupal::service('dsr_deposito.default')->OgmForShareholder(
      $shareholder, 'deposito');

    $result['#markup'] = implode(
      ', ',
      array_map(
        function ($ogm) {
          return $ogm->getFormattedOGM();
        },
        $ogms
      )
    );

    return $result;
  }

}
