<?php

namespace Drupal\dsr_deposito\TwigExtension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;
use Twig\TwigFunction;
use Drupal\banking_ogm\Entity\BankingOGM;

/**
 * Class DsrDepositoTwigExtension.
 */
class DsrDepositoTwigExtension extends AbstractExtension {

  /**
   * {@inheritdoc}
   */
  public function getTokenParsers() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getNodeVisitors() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getFilters() {
    return [
      new TwigFilter('deposito_ogm', [$this, 'depositoOgmFilter']),
      new TwigFilter('deposito_balance', [$this, 'depositoBalanceFilter']),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getTests() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getFunctions() {
    return [
      new TwigFunction('get_deposito_ogm', [$this, 'getDepositoOgm']),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getOperators() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getName() {
    return 'dsr_deposito.twig.extension';
  }

  /**
   * {@inheritdoc}
   */
  public function getDepositoOgms($object) {
    if (empty($object)) {
      return FALSE;
    }

    $ogm_ids = \Drupal::entityQuery('banking_ogm')
      ->accessCheck(FALSE)
      ->condition('type', 'shareholder')
      ->condition('account.entity.type', 'deposito')
      ->condition('account.entity.field_shareholder.target_id', $object->id())
      ->execute();

    if (!$ogm_ids) {
      return [];
    }

    return BankingOGM::loadMultiple(($ogm_ids));
  }

  /**
   * {@inheritdoc}
   */
  public function getDepositoOgm($object) {
    if (empty($object)) {
      return FALSE;
    }

    $ogms = $this->getDepositoOgms($object);
    if ($ogms) {
        return reset($ogms);
    }
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  public function depositoOgmFilter($object) {
    $ogm = $this->getDepositoOgm($object);
    if (!$ogm) {
      return '';
    }
    return $ogm->getFormattedOGM();
  }

  /**
   * {@inheritdoc}
   */
  public function depositoBalanceFilter($object) {
    $ogms = $this->getDepositoOgms($object);
    $balance = '0';
    foreach ($ogms as $ogm) {
      error_log('adding balance ' . $ogm->get('account')->entity->getBalance()['balance_sign']);
      $balance = bcadd(
        $balance,
        $ogm->get('account')->entity ? $ogm->get('account')->entity->getBalance()['balance_sign'] : '0',
        2
      );
    }
    return $balance;
  }

}
