<?php

/**
 * @file
 * Post update scripts for the dsr sign up form module.
 */

use Drupal\accounting\Entity\AccountingAccount;

/**
 * Fill issue and quantity for existing gift certificate accounts.
 */
function dsr_gift_certificates_post_update_fill_issue_and_quantity(&$sandbox) {
  $account_ids = \Drupal::entityQuery('accounting_account')->accessCheck(FALSE)->condition('type', 'cadeau_aandeel')->execute();
  if (!$account_ids) {
    return;
  }

  foreach (AccountingAccount::loadMultiple($account_ids) as $account) {
    if ($account->hasField('field_gift_submission') && $account->get('field_gift_submission')->entity) {
      $submission = $account->get('field_gift_submission')->entity;
      $transaction_data = \Drupal::service('dsr_sign_up_form.default')->getIssueAndQuantity($submission);
      if ($account->hasField('field_issue')) {
        $account->set('field_issue', $transaction_data['issue']);
      }
      if ($account->hasField('field_quantity')) {
        $account->set('field_quantity', $transaction_data['quantity']);
      }
      $account->save();
    }
  }
}
