<?php

namespace Drupal\dsr_gift_certificates\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;


use Drupal\accounting\Event\JournalEntryLineEvent;

/**
 * Class GiftCertificateEventSubscriber.
 *
 * @package Drupal\dsr_gift_certificates
 */
class GiftCertificateEventSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events['rules_journal_entry_line_validated'][] = ['createGiftCertificate', 800];
    return $events;
  }

  /**
   * Subscriber Callback for the event.
   *
   * @param $event
   */
  public function createGiftCertificate(JournalEntryLineEvent $event) {
    $line = $event->journal_entry_line;
    $account = $line->getAccount();

    if ($account->bundle() != 'cadeau_aandeel' || !$account->hasField('field_submission')) {
      return;
    }
    $submission = $account->field_gift_submission->entity;

    $handler_collection = $submission->getWebform()->getHandlers('dsr_gift_certificate_webform_handler');
    $instance_ids = $handler_collection->getInstanceIds();
    if (!count($instance_ids)) {
      return;
    }
    $handler = $handler_collection->get(reset($instance_ids));
    if ($handler->testPaidInFull($submission, $account)) {
      $handler->sendCertificate($submission, $account);
      $account->setState('pending');
      $account->save();
    }
    return;
  }

}
