<?php

namespace Drupal\dsr_gift_certificates\Validate;

use Drupal\Core\Form\FormStateInterface;

use Drupal\accounting\Entity\AccountingAccount;

/**
 * Form API callback. Validate element value.
 */
class ValidateDSRGiftCertificate {

  /**
   * Validates given element.
   *
   * @param array $element
   *   The form element to process.
   * @param \Drupal\Core\Form\FormStateInterface $formState
   *   The form state.
   * @param array $form
   *   The complete form structure.
   */
  public static function validate(array &$element, FormStateInterface $formState, array &$form) {
    $form_key = $element['#parents'];
    $value = $formState->getValue($form_key);

    if (!$value) {
      return;
    }

    $aids = \Drupal::entityQuery('accounting_account')
      ->accessCheck(FALSE)
      ->condition('type', 'cadeau_aandeel')
      ->condition('field_gift_certificate_code', $value, '=')
      ->execute();

    if (count($aids) != 1) {
      $formState->setError(
        $element,
        t('Invalid gift certificate code!')
      );
      return;
    }
    $account = AccountingAccount::load(reset($aids));
    if ($account->get('state')->value == 'open') {
      $formState->setError(
        $element,
        t('The gift certificate is not active yet!')
      );
      return;
    }
    if ($account->get('state')->value == 'closed') {
      $formState->setError(
        $element,
        t('The gift certificate has already been registered!')
      );
      return;
    }
    if ($account->get('field_submission')->target_id) {
      $formState->setError(
        $element,
        t('This gift certificate is already registered!')
      );
      return;
    }
    if ($account->get('state')->value != 'pending') {
      $formState->setError(
        $element,
        t('There is a problem with the gift certificate, please contact us for more information!')
      );
      return;
    }
  }

}
