<?php

/**
 * @file
 * Post update scripts for the dsr sign up form module.
 */

use Drupal\accounting\Entity\AccountingAccount;

/**
 * Fill issue and quantity for existing intekenformulier accounts.
 */
function dsr_sign_up_form_post_update_fill_issue_and_quantity(&$sandbox) {
  $account_ids = \Drupal::entityQuery('accounting_account')->accessCheck(FALSE)->condition('type', 'intekenformulier')->execute();
  if (!$account_ids) {
    return;
  }

  foreach (AccountingAccount::loadMultiple($account_ids) as $account) {
    if ($account->hasField('field_submission') && $account->get('field_submission')->entity) {
      $submission = $account->get('field_submission')->entity;

      $handler_collection = $submission->getWebform()->getHandlers('shareholder_mapping_webform_handler');
      $instance_ids = $handler_collection->getInstanceIds();
      if (!count($instance_ids)) {
        continue;
      }
      $handler = $handler_collection->get(reset($instance_ids));

      $transaction_data = $handler->getIssueAndQuantity($submission);
      if ($account->hasField('field_issue')) {
        $account->set('field_issue', $transaction_data['issue']);
      }
      if ($account->hasField('field_quantity')) {
        $account->set('field_quantity', $transaction_data['quantity']);
      }
      $account->save();
    }
  }
}
