<?php

namespace Drupal\dsr_sign_up_form;

use Drupal\Core\Messenger\MessengerInterface;

use Drupal\shareholder_register\Entity\ShareIssue;
use Drupal\webform\webformSubmissionInterface;

/**
 * Class DsrSignUpService.
 */
class DsrSignUpService implements DsrSignUpServiceInterface {

  /**
   * Drupal\Core\Messenger\MessengerInterface definition.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface
   */
  protected $messenger;

  /**
   * Constructs a new DsrSignUpService object.
   */
  public function __construct(MessengerInterface $messenger) {
    $this->messenger = $messenger;
  }

  /**
   * {@inheritdoc}
   */
  public function getIssueAndQuantity(WebformSubmissionInterface $submission, $shareholder_shares_key = FALSE) {
    if (! $shareholder_shares_key) {
        $keys = array_keys(
            array_filter(
                $submission->getWebform()->getElementsInitializedAndFlattened(),
                function ($el) {return $el['#type'] == 'shareholder_shares';}
            )
        );
        $shareholder_shares_key = reset($keys);
    }

    if (! $shareholder_shares_key) {
        // TODO: log
        return [];
    }
      
    $data = $submission->getData();

    return [
      'issue' => ShareIssue::load($data[$shareholder_shares_key]['share_issue']),
      'quantity' => $data[$shareholder_shares_key]['share_quantity'],
    ];
  }
    
}
