<?php

namespace Drupal\dsr_sign_up_form\Event;

use Symfony\Contracts\EventDispatcher\Event;

use Drupal\shareholder_register\Entity\ShareholderInterface;
use Drupal\webform\Entity\WebformSubmission;

/**
 * Sign up Event Event.
 */
class SignUpEvent extends Event {

  const MAPPED_SIGN_UP_TO_SHAREHOLDER = 'dsr_mapped_sign_up_to_shareholder';

  /**
   * The shareholder.
   *
   * @var \Drupal\shareholder_register\Entity\ShareholderInterface
   */
  protected $shareholder;

  /**
   * The submission.
   *
   * @var \Drupal\webform\Entity\WebformSubmission
   */
  protected $submission;

  /**
   * Constructs the object.
   *
   * @param \Drupal\shareholder_register\Entity\ShareholderInterface $shareholder
   *   The Shareholder.
   * @param \Drupal\webform\Entity\WebformSubmission $submission
   *   The Submission.
   */
  public function __construct(ShareholderInterface $shareholder, WebformSubmission $submission) {
    $this->shareholder = $shareholder;
    $this->submission = $submission;
  }

  /**
   * {@inheritdoc}
   */
  public function getShareholder() {
    return $this->shareholder;
  }

  /**
   * {@inheritdoc}
   */
  public function getSubmission() {
    return $this->submission;
  }

}
