<?php

namespace Drupal\dsr_sign_up_form\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

use Drupal\accounting\Event\JournalEntryLineEvent;

/**
 * Class PaymentStatusEventSubscriber.
 *
 * Re-dispatch payment event as rules event.
 *
 * @package Drupal\dsr_sign_up
 */
class PaymentStatusEventSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events['rules_journal_entry_line_validated'][] = ['createShareTransactionForPaidSignUpAccount', 800];
    return $events;
  }

  /**
   * Subscriber Callback for the event.
   *
   * @param \Drupal\accounting\Event\JournalEntryLineEvent $event
   *   The event.
   */
  public function createShareTransactionForPaidSignUpAccount(JournalEntryLineEvent $event) {
    $line = $event->journal_entry_line;
    $account = $line->getAccount();

    // FIXME: config ?
    if ($account->bundle() != 'intekenformulier' || !$account->hasField('field_submission')) {
      return;
    }

    // Do not create a transaction if one already exists.
    $transaction_ids = \Drupal::entityQuery('share_transaction')
      ->accessCheck(FALSE)
      ->condition('field_account', $account->id())
      ->condition('state', ['draft', 'valid'], 'IN')
      ->execute();
    if (count($transaction_ids)) {
      return;
    }

    $submission = $account->field_submission->entity;

    if (!$submission || !$submission->getWebform()) {
      return;
    }

    $handler_collection = $submission->getWebform()->getHandlers('shareholder_mapping_webform_handler');
    $instance_ids = $handler_collection->getInstanceIds();
    if (!count($instance_ids)) {
      return;
    }
    $handler = $handler_collection->get(reset($instance_ids));
    $handler->performMapping($submission, $account);
  }

}
