<?php

namespace Drupal\dsr_sign_up_form\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

use Drupal\accounting_webform\Plugin\WebformHandler\AccountingAccountWebformHandler;
use Drupal\webform\Entity\WebformSubmission;

/**
 * Class SignupManualConfirmForm.
 */
class SignupManualConfirmForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'signup_manual_confirm_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, WebformSubmission $webform_submission = NULL) {
    $form_state->getStorage()['submission'] = $webform_submission;

    $form['help'] = [
      '#markup' => t('When submitting this form a draft share transaction will be prepared based on this submission.'),
    ];
    $form['quantity'] = [
      '#type' => 'number',
      '#title' => $this->t('Quantity'),
      '#weight' => '0',
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);

    $submission = $form_state->getStorage()['submission'];

    $handler_collection = $submission->getWebform()->getHandlers('shareholder_mapping_webform_handler');
    $instance_ids = $handler_collection->getInstanceIds();
    if (!count($instance_ids)) {
      $form_state->setErrorByName('quantity', $this->t(
          "Webform doesn't have a shareholder_mapping_webform_handler configured!"
      ));
    }

    $handler_collection = $submission->getWebform()->getHandlers();
    $instance_ids = array_keys(
      array_filter(
        iterator_to_array($handler_collection),
        function ($h) {
          return ($h instanceof AccountingAccountWebformHandler);
        }
      )
    );
    if (!count($instance_ids)) {
      $form_state->setErrorByName('quantity', $this->t(
          "Webform doesn't have a accounting_account_webform_handler configured!"
      ));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $submission = $form_state->getStorage()['submission'];

    $handler_collection = $submission->getWebform()->getHandlers();
    $instance_ids = array_keys(
      array_filter(
        iterator_to_array($handler_collection),
        function ($h) {
          return ($h instanceof AccountingAccountWebformHandler);
        }
      )
    );
    if (!count($instance_ids)) {
      throw new \Exception("Internal error");
    }
    $handler = $handler_collection->get(reset($instance_ids));
    $account = $handler->getAccount($submission);

    $handler_collection = $submission->getWebform()->getHandlers('shareholder_mapping_webform_handler');
    $instance_ids = $handler_collection->getInstanceIds();
    if (!count($instance_ids)) {
      throw new \Exception("Internal error");
    }
    $handler = $handler_collection->get(reset($instance_ids));
    $transaction = $handler->performMapping($submission, $account, FALSE);

    if ($transaction) {
      $transaction->set('quantity', $form_state->getValue('quantity'));
      $transaction->save();

      $form_state->setRedirect(
        'entity.share_transaction.edit_form',
        ['share_transaction' => $transaction->id()]
      );
    }
  }

}
