<?php

namespace Drupal\dsr_sign_up_form\Plugin\WebformElement;

use Drupal\Core\Form\FormStateInterface;

use Drupal\webform\Plugin\WebformElement\WebformCompositeBase;
use Drupal\webform\WebformSubmissionInterface;

/**
 * Provides a 'shareholder_identifier' element.
 *
 * @WebformElement(
 *   id = "shareholder_identifier",
 *   label = @Translation("Shareholder Identifier validation"),
 *   description = @Translation("Provides a Shareholder Identifier composite."),
 *   category = @Translation("Shareholder Register"),
 *   multiline = FALSE,
 *   composite = TRUE,
 *   states_wrapper = TRUE,
 * )
 *
 * @see \Drupal\webform\Plugin\WebformElement\WebformCompositeBase
 * @see \Drupal\webform\Plugin\WebformElementBase
 * @see \Drupal\webform\Plugin\WebformElementInterface
 * @see \Drupal\webform\Annotation\WebformElement
 */
class ShareholderIdentifier extends WebformCompositeBase {

  /**
   * {@inheritdoc}
   */
  protected function formatHtmlItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    return $this->formatTextItemValue($element, $webform_submission, $options);
  }

  /**
   * {@inheritdoc}
   */
  protected function formatTextItemValue(array $element, WebformSubmissionInterface $webform_submission, array $options = []) {
    $value = $this->getValue($element, $webform_submission, $options);

    $lines = [];
    /*
    $lines[] = (isset($value['number']) ? $value['number'] : '') .
    (isset($value['mail']) ? ' ' . $value['mail'] : '');
     */
    return $lines;
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultProperties() {
    return [
      'shareholder_number_key' => '',
      'confirmation_text' => '',
      'confirmation_description' => '',
    ] + parent::getDefaultProperties();
  }

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);
    $form['element']['shareholder_number_key'] = [
      '#type' => 'textfield',
      '#title' => 'Shareholder Number Key',
      '#description' => 'The key for the shareholder number element (used for identifier validation).',
    ];
    $form['element']['confirmation_text'] = [
      '#type' => 'textfield',
      '#title' => 'Confirmation text',
      '#description' => 'The text to display if the identifier is invalid.',
    ];
    $form['element']['confirmation_description'] = [
      '#type' => 'textfield',
      '#title' => 'Confirmation description',
      '#description' => 'The description to display if the identifier is invalid.',
    ];
    return $form;
  }

}
