<?php

namespace Drupal\dsr_sign_up_form\Validate;

use Drupal\Core\Form\FormStateInterface;

/**
 * Form API callback. Validate element value.
 */
class ValidateBelgianCompanyID {

  /**
   * Validates given element.
   *
   * @param array $element
   *   The form element to process.
   * @param \Drupal\Core\Form\FormStateInterface $formState
   *   The form state.
   * @param array $form
   *   The complete form structure.
   */
  public static function validate(array &$element, FormStateInterface $formState, array &$form) {
    $form_key = $element['#parents'];
    $value = $formState->getValue($form_key);

    if (!$value) {
      return;
    }

    if (preg_match('/(BE)?([0-9]{4})\.?([0-9]{3})\.?([0-9]{3})/', $value, $matches)) {
      $ogm = $matches[2] . $matches[3] . $matches[4];
      $info = substr($ogm, 0, -2);
      $check = $info % 97;
      $checksum = 97 - substr($ogm, -2);
      if ($check == $checksum) {
        return;
      }
    }
    $formState->setError(
      $element,
      t('The entered belgian company id is not valid!')
    );

  }

}
